"use client";
import Image from "next/image";
import React, { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faBars, faXmark } from "@fortawesome/free-solid-svg-icons";
import Link from "next/link";
import { usePathname, useRouter } from "next/navigation";
import toast from "react-hot-toast";
import Cookies from "js-cookie";
import { useDispatch, useSelector } from "react-redux";
import { useCheckSubscriptionQuery } from "@/services/Api";
import { userLogout } from "@/redux/authSlice";
import { useLogoutUserMutation } from "@/services/Api";

function SideNavbar() {
  const router = useRouter();
  const pathname = usePathname();
  const [openSidebar, setOpenSidebar] = useState(false);
  const dispatch = useDispatch();
  const auth = useSelector((data) => data?.auth);
  const linkClasses = (path) =>
    `flex gap-3 py-2 ${
      pathname.startsWith(path)
        ? "bg-golden rounded-md text-white"
        : "text-[#484F61]"
    }`;

  const toggleOpenSidebar = () => {
    setOpenSidebar(!openSidebar);
  };

  const { data: checkSubscription, refetch: checkSubscriptionRefetch } =
    useCheckSubscriptionQuery();

  useEffect(() => {
    checkSubscriptionRefetch().then((res) => {});
  }, []);

  const [logoutUser] = useLogoutUserMutation();

  const handleLogout = () => {
    dispatch(userLogout(null));
    router.push("/");
    Cookies.remove("role");
    Cookies.remove("authToken");
    localStorage.clear();
    logoutUser()
      .unwrap()
      .then(() => {
        dispatch(userLogout(null));
        router.push("/");
        Cookies.remove("role");
        Cookies.remove("authToken");
        localStorage.clear();
        toast.success("Logout Successful", {
          position: "top-center",
        });
      })
      .catch((error) => {});
  };

  return (
    <div>
      <div
        className={`bg-white h-16 flex z-50 justify-between px-4 items-center ${
          openSidebar ? "hidden" : "block"
        }`}
      >
        <div>
          <FontAwesomeIcon
            icon={faBars}
            size="lg"
            onClick={toggleOpenSidebar}
          />
        </div>
        <div className="flex gap-2">
          <div className="rounded-full bg-red-800">
            {(auth?.userDetail?.media &&
              auth?.userDetail?.media[0]?.original_url && (
                <img
                  src={auth?.userDetail?.media[0]?.original_url}
                  alt="profile"
                  className="h-16 w-16 rounded-full object-cover"
                />
              )) || (
              <div className="h-12 w-12 rounded-full bg-golden flex items-center justify-center">
                <span className="text-2xl font-bold text-white">
                  {auth?.userDetail?.name?.charAt(0).toUpperCase()}
                </span>
              </div>
            )}
          </div>
          <div className="flex flex-col justify-center">
            <p className="text-[14px] font-bold">{auth?.userDetail?.name}</p>
            <p className="text-[12px] font-normal">
              {auth?.userDetail?.role?.name}
            </p>
          </div>
        </div>
      </div>
      <div
        className={`fixed z-10 top-0 left-0 bg-white h-full dashboard-sidebar ${
          openSidebar ? "block" : "hidden"
        } lg:block w-[280px] min-h-screen max-h-[1020px] `}
      >
        {/* <div className="flex flex-col justify-between lg:min-h-full min-h-[850px]">
          <div className="h-full"> */}
        <div className="p-6 w-full flex justify-center">
          <Image
            src="/assets/navbar/logo1.svg"
            height={128}
            width={160}
            className="w-40 h-32"
            alt="Final Logo"
            onClick={toggleOpenSidebar}
            quality={100}
          />
        </div>
        <div className="overflow-y-auto flex flex-col justify-between customScrollbar">
          <ul>
            <li>
              <Link
                href="/dashboard"
                className={`flex items-center gap-3 text-[14px] font-normal pl-8 py-4 mx-4 ${linkClasses(
                  "/dashboard"
                )}`}
              >
                {pathname.startsWith("/dashboard") ? (
                  <Image
                    src="/assets/dashboard/sidebar/dashboardWhite.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                ) : (
                  <Image
                    src="/assets/dashboard/sidebar/dashboardGray.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                )}
                Dashboard
              </Link>
            </li>
            <li>
              <Link
                href="/courses"
                className={`flex items-center gap-3 text-[14px] font-normal pl-8 py-4 mx-4 ${linkClasses(
                  "/courses"
                )}`}
              >
                {pathname.startsWith("/courses") ? (
                  <Image
                    src="/assets/dashboard/sidebar/coursesWhite.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                ) : (
                  <Image
                    src="/assets/dashboard/sidebar/coursesGray.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                )}
                Courses
              </Link>
            </li>
            <li>
              <Link
                href="/certifications"
                className={`flex items-center gap-3 text-[14px] font-normal pl-8 py-4 mx-4 ${linkClasses(
                  "/certifications"
                )}`}
              >
                {pathname.startsWith("/certifications") ? (
                  <Image
                    src="/assets/dashboard/sidebar/certificationsWhite.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                ) : (
                  <Image
                    src="/assets/dashboard/sidebar/certificationsGray.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                )}
                Certifications
              </Link>
            </li>
            <li>
              <Link
                href="/assignments"
                className={`flex items-center gap-3 text-[14px] font-normal pl-8 py-4 mx-4 ${linkClasses(
                  "/assignments"
                )}`}
              >
                {pathname.startsWith("/assignments") ? (
                  <Image
                    src="/assets/dashboard/sidebar/assignmentsWhite.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                ) : (
                  <Image
                    src="/assets/dashboard/sidebar/assignmentsGray.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                )}
                Assignments
              </Link>
            </li>
            <li>
              <Link
                href="/profile"
                className={`flex items-center gap-3 text-[14px] font-normal pl-8 py-4 mx-4 ${linkClasses(
                  "/profile"
                )}`}
              >
                {pathname.startsWith("/profile") ? (
                  <Image
                    src="/assets/dashboard/sidebar/profileWhite.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                ) : (
                  <Image
                    src="/assets/dashboard/sidebar/profileGray.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                )}
                Profile
              </Link>
            </li>
            <li>
              <Link
                href="/payment"
                className={`flex items-center gap-3 text-[14px] font-normal pl-8 py-4 mx-4 ${linkClasses(
                  "/payment"
                )}`}
              >
                {pathname.startsWith("/payment") ? (
                  <Image
                    src="/assets/dashboard/sidebar/paymentsWhite.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                ) : (
                  <Image
                    src="/assets/dashboard/sidebar/paymentsGray.png"
                    alt="dashboardLogo"
                    className="h-4 w-4"
                    height={4}
                    width={4}
                  />
                )}
                Payments
              </Link>
            </li>
          </ul>
          <div className="mt-6">
            <ul>
              <li>
                <Link
                  href="/contact-us"
                  className="flex items-center gap-3 text-[14px] font-normal pl-8 py-4 text-[#484F61]"
                >
                  {pathname.startsWith("/help") ? (
                    <Image
                      src="/assets/dashboard/sidebar/helpWhite.png"
                      alt="dashboardLogo"
                      className="h-4 w-4"
                      height={4}
                      width={4}
                    />
                  ) : (
                    <Image
                      src="/assets/dashboard/sidebar/helpGray.png"
                      alt="dashboardLogo"
                      className="h-4 w-4"
                      height={4}
                      width={4}
                    />
                  )}
                  Help
                </Link>
              </li>
              <li>
                <button
                  onClick={handleLogout}
                  className="flex items-center gap-3 text-[14px] font-normal pl-8 py-4 text-[#484F61]"
                >
                  {pathname.startsWith("/logout") ? (
                    <Image
                      src="/assets/dashboard/sidebar/logoutGray.png"
                      alt="dashboardLogo"
                      className="h-4 w-4"
                      height={4}
                      width={4}
                    />
                  ) : (
                    <Image
                      src="/assets/dashboard/sidebar/logoutGray.png"
                      alt="dashboardLogo"
                      className="h-4 w-4"
                      height={4}
                      width={4}
                    />
                  )}
                  Log out
                </button>
              </li>
            </ul>
          </div>
        </div>
        {/* </div>
        </div> */}
      </div>

      {openSidebar && (
        <div
          className="fixed inset-0 bg-black opacity-20 z-0 lg:hidden"
          onClick={toggleOpenSidebar}
        >
          <button
            className="absolute z-20 right-4 top-4 text-white"
            onClick={toggleOpenSidebar}
          >
            <FontAwesomeIcon icon={faXmark} size="2x" className="text-white" />
          </button>
        </div>
      )}
    </div>
  );
}

export default SideNavbar;
